


/**
 ******************************************************************************
 *
 * @file        MG32_Button_API.c
 * @brief       
 
 * @par         Project
 *              Mouse
 * @version     V1.00
 * @date        2022/03/23
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

#ifndef __WHEEL_H
#define __WHEEL_H

#include "MG32.h"

/**
 * @name  define
 */
///@{

/*Pin configure*/
#define WHEEL_IOM_PORT            IOMB

#define WHEEL_ZA_IOM_PIN          PINB(0)
#define WHEEL_ZB_IOM_PIN          PINB(1)

#define WHEEL_ZA_IOM_AFS          0
#define WHEEL_ZB_IOM_AFS          0


/*Wheel control*/
#define __API_Wheel_GetStatus()   ((uint8_t)(PB1<<4) | (uint8_t)PB0)  /*!< To get Wheel pin status.*/     


#define WHEEL_STATE_MASK          0x00FFFFFF                          /*!< Wheel status mask.*/


///@}


/**
 * @name  typedef
 */
///@{

/*! @struct WheelCTR_TypeDef
    @brief  wheel control parameter.
*/ 
typedef struct 
{
    union 
    {
        uint8_t  B[4];
        uint32_t W;    
    }Wheel_Status;
    
    uint8_t  Wheel_ChangeFlag;
     int8_t  Wheel_Data;
    uint8_t  _PADDING[2];          // The parameter is for struct alignment boundary.
}WheelCTR_TypeDef;


///@}

/**
 * @name  variables
 */
///@{

extern WheelCTR_TypeDef Wheel_CTR;

///@}

/**
 * @name  function
 */
///@{

void API_Wheel_Init(void);
void API_Wheel_DetectStatus(void);
///@}

#endif

